IF OBJECT_ID('UFD_EXP_CTB_MOV_RC_CRED_LOTE') IS NOT NULL
	BEGIN
		DROP FUNCTION UFD_EXP_CTB_MOV_RC_CRED_LOTE
	END

GO	
 
CREATE FUNCTION UFD_EXP_CTB_MOV_RC_CRED_LOTE(@CD_EMP		INT,
										    @CD_FILIAL	INT,
										    @DT_INI		DATETIME,
										    @DT_FIM		DATETIME)		
RETURNS @RS_RETURN TABLE(
			CD_EMP					INT,
			CD_FILIAL				INT, 
			VL_PGTO					MONEY,
			VL_JUR					MONEY,
			VL_DESC					MONEY,
			VLR_GLOSA				MONEY,
			CD_CNT					INT,
			CD_CLI					INT,
			RZ_CLI					VARCHAR(200),
			HIST_LANCTO				VARCHAR(150),
			NR_DP					INT, 
			ANO						INT,
			PARC					INT, 
			CD_RC_DEB				INT,
			CD_RC_CRED_LOTE			INT,			
			DT_PAG					DATETIME)
AS
BEGIN       

	DECLARE @CD_GRP_ECON			INT
	
	SET @CD_GRP_ECON = (SELECT PRC_GRP_ECON_PRC_FILIAL.CD_GRP_ECON
						FROM PRC_FILIAL
							INNER JOIN PRC_GRP_ECON_PRC_FILIAL ON
								PRC_FILIAL.CD_EMP = PRC_GRP_ECON_PRC_FILIAL.CD_EMP AND 
								PRC_FILIAL.CD_FILIAL = PRC_GRP_ECON_PRC_FILIAL.CD_FILIAL
						WHERE
						    PRC_FILIAL.CD_EMP = @CD_EMP
						    AND PRC_FILIAL.CD_FILIAL = @CD_FILIAL
						    AND PRC_FILIAL.FILIAL_MTZ_GRP_ECON = 1)
	
	IF ISNULL(@CD_GRP_ECON,0) = 0 
		BEGIN
			RETURN
		END
		

	INSERT INTO @RS_RETURN 
		SELECT 
			RC_CRED.CD_EMP, 
			RC_CRED.CD_FILIAL, 
			RC_CRED.VL_PGTO,
		    RC_CRED.VL_JUR,
		    RC_CRED.VL_DESC,
		    RC_CRED.VLR_GLOSA,
		    BC_LANC.CD_CNT,
		    RC_DEB.CD_CLI,
			RC_CLI.RZ_CLI,
		    HIST_LANC,
		    RC_DEB.NR_DP, 
			RC_DEB.ANO,
		    RC_DEB.PARC, 
			RC_DEB.CD_RC_DEB,		    
		    RC_CRED_LOTE.CD_RC_CRED_LOTE,    
			RC_CRED.DT_PAG
		FROM 
			RC_CRED 
			INNER JOIN RC_CRED_LOTE_RC_CRED ON 
			    RC_CRED.CD_EMP = RC_CRED_LOTE_RC_CRED.CD_EMP AND
			    RC_CRED.CD_FILIAL = RC_CRED_LOTE_RC_CRED.CD_FILIAL AND 
			    RC_CRED.CD_RC_DEB = RC_CRED_LOTE_RC_CRED.CD_RC_DEB AND
			    RC_CRED.CD_DP_LANC = RC_CRED_LOTE_RC_CRED.CD_DP_LANC 
				
		    INNER JOIN RC_CRED_LOTE ON 
			    RC_CRED_LOTE_RC_CRED.CD_EMP = RC_CRED_LOTE.CD_EMP AND
			    RC_CRED_LOTE_RC_CRED.CD_RC_CRED_LOTE = RC_CRED_LOTE.CD_RC_CRED_LOTE 
			
			INNER JOIN RC_CRED_LOTE_BC_LANC ON 
			    RC_CRED_LOTE.CD_EMP = RC_CRED_LOTE_BC_LANC.CD_EMP AND
			    RC_CRED_LOTE.CD_RC_CRED_LOTE = RC_CRED_LOTE_BC_LANC.CD_RC_CRED_LOTE 
				
		    INNER JOIN BC_LANC ON 
			    RC_CRED_LOTE_BC_LANC.CD_EMP = BC_LANC.CD_EMP AND
			    RC_CRED_LOTE_BC_LANC.CD_BC_LANC = BC_LANC.CD_BC_LANC 
			
			INNER JOIN RC_DEB ON 
			    RC_CRED.CD_EMP = RC_DEB.CD_EMP AND 
			    RC_CRED.CD_FILIAL = RC_DEB.CD_FILIAL AND
			    RC_CRED.CD_RC_DEB = RC_DEB.CD_RC_DEB
		    
		    INNER JOIN RC_CLI ON
			    RC_DEB.CD_EMP = RC_CLI.CD_EMP AND
			    RC_DEB.CD_CLI = RC_CLI.CD_CLI
		
		WHERE
			RC_CRED.CD_EMP			= @CD_EMP
			AND RC_CRED.CD_FILIAL	IN (SELECT CD_FILIAL 
										FROM PRC_GRP_ECON_PRC_FILIAL
										WHERE CD_GRP_ECON = @CD_GRP_ECON)
			AND RC_CRED.DT_PAG		BETWEEN @DT_INI AND @DT_FIM
    
		ORDER BY 
			RC_CRED.DT_PAG, RC_CRED_LOTE.CD_RC_CRED_LOTE, RC_DEB.CD_CLI, RC_DEB.NR_DP, RC_DEB.ANO, RC_DEB.PARC, BC_LANC.CD_CNT, RC_DEB.HIST										
		
	RETURN
		
END		